using System;
using System.Globalization;

class Program
{
    static void Main()
    {
        CultureInfo.CurrentCulture = CultureInfo.InvariantCulture;

        int n = int.Parse(Console.ReadLine() ?? "0");

        long[] x = Array.ConvertAll(
            (Console.ReadLine() ?? "").Split(new[] { ' ', '\t' }, StringSplitOptions.RemoveEmptyEntries),
            long.Parse
        );

        long[] h = Array.ConvertAll(
            (Console.ReadLine() ?? "").Split(new[] { ' ', '\t' }, StringSplitOptions.RemoveEmptyEntries),
            long.Parse
        );

        double[] ans = new double[n];
        for (int i = 0; i < n; i++) ans[i] = double.PositiveInfinity;

        // 1) ????? ???????
        for (int i = 0; i < n; i++)
        {
            for (int j = 0; j < n; j++)
            {
                if (i == j) continue;
                if (h[j] < h[i]) continue;

                double dx = (double)x[j] - x[i];
                double dy = (double)h[j] - h[i];
                double dist = Math.Sqrt(dx * dx + dy * dy);

                if (dist < ans[i]) ans[i] = dist;
            }
        }

        // 2) ??????
        for (int i = 0; i + 1 < n; i++)
        {
            double xi = x[i];
            double hi = h[i];
            double xj = x[i + 1];
            double hj = h[i + 1];

            // ????????? t, y ?? ????? ???????
            double t = (hi + xi - hj + xj) / 2.0;
            double y = hi - t + xi; // ??? ?? ????? ???????, ????????

            double L = t - xi;      // ?????? ????? ???????? ? s
            double R = xj - t;      // ?????? ?????? ???????? ? u

            for (int k = 0; k < n; k++)
            {
                double xk = x[k];
                double hk = h[k];

                // ??????? A -> P : S(s) = (xi + s, hi - s), s in [0, L]
                // ?????: hi - s >= hk => s <= hi - hk
                double sMax = Math.Min(L, hi - hk);
                if (sMax >= 0)
                {
                    // ??????????
                    double s0 = ((xk - xi) + (hi - hk)) / 2.0;
                    double sStar = Clamp(s0, 0.0, sMax);

                    double sx = xi + sStar;
                    double sy = hi - sStar;
                    if (sy >= hk) // ????? ?? ?????????
                    {
                        double dx = sx - xk;
                        double dy = sy - hk;
                        double dist = Math.Sqrt(dx * dx + dy * dy);
                        if (dist < ans[k]) ans[k] = dist;
                    }
                }

                // ??????? P -> B : T(u) = (t + u, y + u), u in [0, R]
                // ?????: y + u >= hk => u >= hk - y
                double uMin = Math.Max(0.0, hk - y);
                double uMax = R;
                if (uMin <= uMax)
                {
                    double u0 = ((xk - t) + (hk - y)) / 2.0;
                    double uStar = Clamp(u0, uMin, uMax);

                    double ux = t + uStar;
                    double uy = y + uStar;
                    if (uy >= hk)
                    {
                        double dx = ux - xk;
                        double dy = uy - hk;
                        double dist = Math.Sqrt(dx * dx + dy * dy);
                        if (dist < ans[k]) ans[k] = dist;
                    }
                }
            }
        }

        // ?????
        for (int i = 0; i < n; i++)
        {
            if (double.IsPositiveInfinity(ans[i]))
                Console.WriteLine("-1");
            else
                Console.WriteLine(ans[i].ToString("0.##########", CultureInfo.InvariantCulture));
        }
    }

    static double Clamp(double v, double lo, double hi)
    {
        if (v < lo) return lo;
        if (v > hi) return hi;
        return v;
    }
}